local mods, actorCmds

return Def.ActorFrame {
	InitCommand = function(self)
	end,

	OnCommand = function(self)
		function m(beat,mod)
			table.insert(mods,{beat,mod});
		end
		
		local screen = SCREENMAN:GetTopScreen()

		local null = self:GetChild('NullActorFrame')

		local p1 = screen:GetChild('PlayerP1')
		local p2 = screen:GetChild('PlayerP2') or null

		if not p1 then
			for i,v in pairs(screen:GetChild('')) do
				if tostring(v):find('Player') then
					p1 = v
					break
				end
			end
		end

		local players = {p1, p2}

		local p1state = GAMESTATE:GetPlayerState(PLAYER_1)
		local p2state = GAMESTATE:GetPlayerState(PLAYER_2)

		local column1 = '*10 flip,*10 no invert'
		local column2 = '*10 flip,*10 -100 invert'
		local column3 = '*10 invert,*10 no flip'
		local columnReset = '*99 no invert,*99 no flip'

		mods = {
			{0, '*99 2.25x,*99 dark,*99 200 tornado,*99 55 stealth,*99 blind'},
			{3, '*2 no dark,*10 no tornado,*2 no stealth'},
			{4, '*99 dark,*99 stealth'},
			{11, '*99 -100 tiny,*99 no stealth', columnReset},
			{11.25, '*5 no tiny'},
			{12, '*99 -150 tiny'},
			{12.25, '*5 no tiny'},
			{12.75, '*99 -150 tiny'},
			{13, '*5 no tiny'},
			{13.5, '*99 -150 tiny'},
			{13.75, '*10 no tiny'},
			{18, 'no dark'},
			{20, '*9999 no drunk'},
			{28, '*99 invert'},
			{30, '*99 55 stealth,*99 -50 tiny,*99 no invert'},
			{30.25, '*2 no stealth,*2 no tiny'},
			{32, 'dark,*0.5 xmode,*0.5 -100 tornado,*0.5 1x,*0.5 50 flip'},
			{33, '*0.5 55 stealth,2000 dizzy'},
			{40, '*99 no stealth,*999 no dizzy'},
			{52, 'no xmode,no tornado,2.25x,no flip'},
			{56, '*99 no stealth,*99 150 beat,*99 drunk,*99 no dark'},
			{86, 'no beat,no drunk,dark'},
			{88, '*99 no mini'},
			{104, '*2 no stealth,*0.5 500 hallway,*2 no drunk,no dark,*2 bumpy', columnReset},
			{112, 'distant,*4 dark,*4 no bumpy'},
			{118, '*2 no stealth,*99 no drunk,*2 no dark', columnReset},
			{120, '*99 no mini,*0.7 hallway,*0.3 -55 tornado'},
			{128, '*0.7 distant,*0.5 no tornado'},
			{136, '*0.7 hallway,*0.3 -55 tornado'},
			{144, '*0.7 distant,*0.5 no tornado'},
			{148, '*3 overhead,*99 -100 tiny'},
			{148.25, '*5 no tiny'},
			{148.75, '*99 -100 tiny'},
			{149, '*5 no tiny'},
			{149.5, '*99 -100 tiny'},
			{149.75, '*5 no tiny'},
			{150, '*99 -100 tiny'},
			{150.25, '*5 no tiny'},
			{167, '*4 no xmode,*99 2000 dizzy'},
			{167.99, '*9999 no dizzy'},
			{180, '*99 no tipsy,*99 -100 tiny'},
			{180.25, '*5 no tiny'},
			{180.75, '*99 -100 tiny'},
			{181, '*5 no tiny'},
			{181.5, '*99 -100 tiny'},
			{181.75, '*5 no tiny'},
			{182.25, '*99 -100 tiny'},
			{182.5, '*5 no tiny'},
			{183, '*99 -100 tiny'},
			{183.25, '*5 no tiny'},
			{183.5, '*99 -100 tiny'},
			{183.75, '*5 no tiny'},
			{184, '*99 dark,*5 500 tornado,*99 500 bumpy,*99 1x,*2 80 stealth'},
			{200, '*15 no tornado,*15 no bumpy,*10 2.25x,*99 no stealth,*10 no dark'},
			{214, '*99 no tipsy,*99 dark'},
			{223, '*99 -100 tiny,*99 no xmode'},
			{223.25, '*5 no tiny'},
			{223.5, '*99 -100 tiny'},
			{223.75, '*5 no tiny'},
			{224, '*99 -100 tiny'},
			{224.25, '*5 no tiny'},
			{224.75, '*99 -100 tiny'},
			{225, '*5 no tiny'},
			{225.5, '*99 -100 tiny'},
			{225.75, '*5 no tiny'},
			{232, '*2 no stealth,*2 no dark'},
			--god, i hate sm5 so much
			{235.51, '*99 -100 tiny'},
			{235.751, '*5 no tiny'},
			{236.1, '*99 -100 tiny'},
			{236.251, '*5 no tiny'},
			{239.51, '*99 -100 tiny'},
			{239.751, '*5 no tiny'},
			{240.1, '*99 -100 tiny'},
			{240.251, '*5 no tiny'},
			{248, '*10 no tipsy,*2 500 distant'},
			{250, '*4 overhead'},
			{252, '*4 xmode,*4 1.5x,*4 -20 centered,*4 25 mini'},
			{312, '*99 no xmode,*99 -100 tiny,*99 reverse,*99 no tipsy,*99 no centered,*99 no mini'},
			{312.25, '*5 no tiny'},
			{312.5, '*99 -100 tiny,*99 no reverse'},
			{312.75, '*5 no tiny'},
			{313, '*99 -100 tiny,*99 reverse'},
			{313.25, '*5 no tiny'},
			{313.75, '*99 -100 tiny,*99 no reverse'},
			{314, '*5 no tiny'},
			{314.5, '*99 -100 tiny,*99 reverse'},
			{314.75, '*5 no tiny'},
			{315.25, '*99 -100 tiny,*99 no reverse'},
			{315.5, '*5 no tiny'},
			{316, '*5 500 drunk,*5 500 tipsy,*5 500 tornado,*5 xmode,*5 dark,*5 55 stealth'}
		}

nightlyflashes={{5,10},{52,54}}		

for i,v in pairs(nightlyflashes) do
    for beat=v[1],v[2] do
        m(beat, '*99 55 stealth')
		m(beat+.25, '*99 stealth')
    end
end

local swaps = {column1,column2,column3}
	for beat=5.1,10.5,1 do
		m(beat,swaps[math.random(2,table.getn(swaps))])
	end

slowflashes={{14,17},{226,231},{252,299}}

for i,v in pairs(slowflashes) do
    for beat=v[1],v[2] do
        m(beat, '*3 stealth')
		m(beat+.5, '*3 no stealth')
    end
end

for beat=18,19,1 do
	m(beat, '*99 500 drunk')
	m(beat+.125, '*99 -500 drunk')
	m(beat+.25, '*99 500 drunk')
	m(beat+.375, '*99 -500 drunk')
	m(beat+.5, '*99 500 drunk')
	m(beat+.625, '*99 -500 drunk')
	m(beat+.75, '*99 500 drunk')
	m(beat+.875, '*99 -500 drunk')

end
for beat=20.1,26.1,1 do
	m(beat, '*14 200 tipsy')
	m(beat+.25, '*18 no tipsy')
end

for beat=20.1,33,4 do
	m(beat, '*99 55 stealth,*99 -50 tiny')
	m(beat+.25, '*2 no stealth,*2 no tiny')
end

for beat=60,85,4 do
	m(beat, '*25 55 stealth,*25 tiny,*25 confusion,*25 250 distant')
	m(beat+.25, '*2 no stealth,no tiny,*2 no confusion,*2 overhead')
end

jumpup={{86,87},{118,119}}

for i,v in pairs(jumpup) do
    for beat=v[1],v[2] do
        m(beat, '*15 -150 mini')
		m(beat+.25, '*10 200 mini')
		m(beat+.5, '*15 -150 mini')
		m(beat+.75, '*10 200 mini')
    end
end

blinkeng={{88,103},{112,117}}

for i,v in pairs(blinkeng) do
    for beat=v[1],v[2] do
        m(beat, '*10 200 drunk,*99 55 stealth,*99 no flip,*99 no invert')
		m(beat+.5, '*10 -200 drunk,*99 stealth,*99 flip,*99 -100 invert')
	end
end

tititi={{151,151.75},{215,215.75},{251,251.75}}

for i,v in pairs(tititi) do
    for beat=v[1],v[2] do
        m(beat, '*99 -100 tiny')
		m(beat+.125, '*8 no tiny')
		m(beat+.25, '*99 -100 tiny')
		m(beat+.375, '*8 no tiny')
		m(beat+.5, '*99 -100 tiny')
		m(beat+.625, '*8 no tiny')
	end
end

xmodes={{152,166},{216,222}}

for i,v in pairs(xmodes) do
    for beat=v[1],v[2] do
        m(beat, '*6 -55 xmode')
		m(beat+.5, '*6 55 xmode')
	end
end

tipy={{168,179},{208,213},{232,247},{300,311}}

for i,v in pairs(tipy) do
    for beat=v[1],v[2] do
        m(beat, '*16 250 tipsy')
		m(beat+.25, '*16 -250 tipsy')
		m(beat+.5, '*16 250 tipsy')
		m(beat+.75, '*16 -250 tipsy')
	end
end

for beat=203.5,208,4 do
	m(beat, '*99 -100 tiny,*99 55 stealth')
	m(beat+.25, '*5 no tiny,*5 no stealth')
end

		local rot = function()
			p1:linear(3)
			p1:addrotationz(45)
			p2:linear(3)
			p2:addrotationz(-45)
		end

		local reset = function()
			for i=1, #players do
				players[i]
					:linear(1)
					:rotationz(0)
					:skewx(0)
			end
		end

		local skew1 = function()
			p1:linear(0.2)
			p1:skewx(0.5)
			p2:linear(0.2)
			p2:skewx(-0.5)
		end

		local skew2 = function()
			p1:linear(0.2)
			p1:skewx(-0.5)
			p2:linear(0.2)
			p2:skewx(0.5)
		end

		local ending = function()
			p1:linear(1)
			p1:addrotationz(-45)
			p2:linear(1)
			p2:addrotationz(45)
			p2:y(SCREEN_CENTER_X+70)
		end
		
		local instantReset = function()
			for i=1, #players do
				players[i]
					:rotationz(0)
					:skewx(0)
			end
		end

		actorCmds = {
			{33, rot},
			{52, reset},
			{168, reset},
			{223, instantReset},
			{251, ending},
			{312, instantReset}
		}

skews={{152,166},{216,222}}

for i,v in pairs(skews) do
    for beat=v[1],v[2] do
        table.insert(actorCmds, {beat, skew1})
		table.insert(actorCmds, {beat+.5, skew2})
	end
end

		for i=#actorCmds, 1, -1 do
			if GAMESTATE:GetSongBeat() > actorCmds[i][1] then
				table.remove(actorCmds, i)
			end
		end

		p1:stopeffect()
		p2:stopeffect()

		local firstRun = true
		self:SetUpdateFunction(function(self, delta)
			local currentBeat = GAMESTATE:GetSongBeat()

			for i=1, #mods do
				local mod = mods[i]
				if not mod.done and currentBeat >= mod[1] then
					local modstr = table.concat({ unpack(mod, 2) }, ',')
					p1state:SetPlayerOptions('ModsLevel_Song', p1state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					p2state:SetPlayerOptions('ModsLevel_Song', p2state:GetPlayerOptionsString('ModsLevel_Song')..','..modstr)
					mod.done = true

					if not firstRun then
						break
					end
				end
			end

			for i=1, #actorCmds do
				local command = actorCmds[i]
				if not command.done and currentBeat > command[1] then
					command[2]()
					command.done = true
				end
			end
			
			for i=1,2 do
				SCREENMAN:GetTopScreen():GetChild('LifeP'..i):visible(false);
                SCREENMAN:GetTopScreen():GetChild('ScoreP'..i):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Overlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('Underlay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('BPMDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('StageDisplay'):visible(false);
				SCREENMAN:GetTopScreen():GetChild('SongTitle'):visible(false);
				SCREENMAN:GetTopScreen():GetChild("SongMeterDisplay" .. PlayerNumberToString(i-1)):visible(false);
				SCREENMAN:GetTopScreen():GetChild("StepsDisplay" .. PlayerNumberToString(i-1)):visible(false);
			end

			if firstRun then
				p1:finishtweening()
				p2:finishtweening()
			end
			firstRun = false
		end)
	end,

	Def.Quad{ OnCommand = function(self) self:sleep(1000) end },
	Def.ActorFrame{ Name='NullActorFrame' },
	
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_1)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP1'):GetChild('Judgment')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.25)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
	Def.ActorProxy {
		Name = "JudgeProxy",
		Condition="GAMESTATE:IsPlayerEnabled(PLAYER_2)",
		BeginCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			local Judge1 = SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment');
			if Judge1 then 
				self:SetTarget(SCREENMAN:GetTopScreen():GetChild('PlayerP2'):GetChild('Judgment')); 
				Judge1:visible(true);
			else 
				self:hibernate(1);
			end
		end
		end,
		OnCommand = function(self)
		if GAMESTATE:IsPlayerEnabled(PLAYER_1) and GAMESTATE:IsPlayerEnabled(PLAYER_2) then
			self:x(SCREEN_WIDTH*0.75)
			self:y(SCREEN_CENTER_Y)
			self:zoom(0.8);
		else
			self:zoom(0.8)
			self:x(SCREEN_CENTER_X)
			self:y(SCREEN_CENTER_Y)
		end
		end,
	};
}
